/*
 * Decompiled with CFR 0.152.
 */
package zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ZXing {
    public static void main(String[] args) {
        String pathname = args[0];
        String textToQr = "prueba de escritura";
        try {
            String text = ZXing.readQR(pathname);
            System.out.print(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeQR(String text, String pathname) throws WriterException, IOException {
        int width = 600;
        int height = 400;
        String imageFormat = "png";
        BitMatrix bitMatrix = new QRCodeWriter().encode(text, BarcodeFormat.QR_CODE, width, height);
        FileOutputStream outputStream = new FileOutputStream(new File(pathname));
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)imageFormat, (OutputStream)outputStream);
    }

    private static String readQR(String pathname) throws FormatException, ChecksumException, NotFoundException, IOException {
        FileInputStream qrInputStream = new FileInputStream(pathname);
        BufferedImage qrBufferedImage = ImageIO.read(qrInputStream);
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(qrBufferedImage);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        MultiFormatReader reader = new MultiFormatReader();
        Result stringBarCode = reader.decode(bitmap);
        return stringBarCode.getText();
    }
}

